
/**
 * @file parser.h
 * @author Henrik Sandklef
 * @date 25 Nov 2015
 * @brief Functions to parse arguments from user
 *
 */

/**
 * @brief Given an 'array' of int in string format, this function
 * returns a list of intgers.
 *
 * \warning { This function allocates dynamically. Make sure you free
 * the memory }

 *
 * @param int size - number of arguments in 
 * @param int int_strings - integers in string format
 * 
 * @return @c Pointer to int (an 'array')
 */
int * strings_to_ints(int size, char **int_strings);

/**
 * @brief Frees the memory allocated by strings_to_ints
 *
 * @param int *p - memory to free
 * 
 */
void free_ints(int  *p);

/**
 * @brief Frees the memory allocated by strings_to_ints and sets the pointer to NULL
 *
 * @param int *p - memory to free
 * 
 */
#define FREE_INTS(p) free_ints(p); p=NULL;
